' Gettemp.exe  A simple program that sends out a CRLF on a com port and then
'              listens and prints on screen any reply received.
'
' Requirements: MS-Windows + .NET 2.0
'
' NOTES:
' Converted from the original gettemp.vb that was sending out continous
' characters to power a microcontroller off the RS-232 TX line whilst listening
' for replies on the RX line. This code is for the Atmel AVR ATtiny85 project 
' mcu_0055 that still uses RS232 but is now powered externally (using a USB to TTL
' converter board with an FTDI chip). The modifications are:
' - instead of sending continous 0x00 we only send a single 0x0D (Chr13) CRLF
' 
'
'
' Author: M. Post
' Last Modified: 12 January 2013
' Written in: Visual Basic 2005 (version 8) Express Edition
'
' This site was very helpful regarding serial ports"
' http://www.innovatic.dk/knowledg/SerialCOM/SerialCOM.htm
'

Imports System
Imports System.IO.Ports.SerialPort
Imports System.Threading
Imports System.IO.Ports



Module gettemp

    Dim arg_comport As String = "COM8"
    Dim WithEvents myComport As New SerialPort
    Dim timeout_seconds As Int16 = 6  ' maximum number of seconds to listen for data
    Private child_trd As Thread

    ' create an event handler for when data is available in the serial port buffer
    Private Sub Data_Received(ByVal sender As System.Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles myComport.DataReceived

    End Sub

    Sub sleep(ByVal seconds)
        ' simple sleep function in seconds

        Dim starttime As DateTime
        Dim elapsed As Double
        Dim sleep_loop As Int16 = 1
        starttime = New DateTime(Now.Year, Now.Month, Now.Day, Now.Hour, Now.Minute, Now.Second)

        While sleep_loop = 1

            elapsed = DateDiff("s", starttime, Now(), 0, 0)

            If elapsed >= seconds Then
                sleep_loop = 0
            End If

        End While

    End Sub

    Private Sub Child_Thread()

        ' ---- child process (listen) ----
        ' ---- child process (listen) ----
        ' ---- child process (listen) ----
        ' ---- child process (listen) ----

        Dim starttime As DateTime
        Dim elapsed As Double
        Dim do_readloop As Int16 = 1

        starttime = New DateTime(Now.Year, Now.Month, Now.Day, Now.Hour, Now.Minute, Now.Second)

        Dim RXdata As String = ""
        Dim newdata As String = ""
        Dim br As Int16
        br = myComport.BytesToRead
        Dim rcvBuf(0) As Byte

        While do_readloop = 1

            Do While ((myComport.BytesToRead <> 0))

                myComport.Read(rcvBuf, 0, 1)

                'RXdata = Hex(rcvBuf(0)).PadLeft(2, "0") + " "   // displays Hex output
                RXdata = Convert.ToChar(rcvBuf(0))

                Console.Write(RXdata)

            Loop

            br = myComport.BytesToRead

            elapsed = DateDiff("s", starttime, Now(), 0, 0)

            If elapsed >= timeout_seconds Then         ' exit the loop if we're hitting the timeout 
                do_readloop = 0                        ' NOTE: the parent process runs one second longer
            End If                                     ' as it closes the serial port

        End While


 
    End Sub


    Sub Main()

        Dim argument As String = ""
        Dim inputArgument As String = ""
        Dim cnt As Int16

        ' grab the commandline arguments
        For Each s As String In My.Application.CommandLineArgs
            If s.ToLower.StartsWith(inputArgument) Then
                argument = s.Remove(0, inputArgument.Length)
            End If

            If cnt = 0 Then
                ' com port is specified, use this
                arg_comport = argument

            End If

            cnt = cnt + 1

        Next

        ' ---- parent process (send) ----
        ' ---- parent process (send) ----
        ' ---- parent process (send) ----
        ' ---- parent process (send) ----

        Dim starttime As DateTime
        Dim elapsed As Double
        Dim sendchar As String = Chr(13)
        Dim do_sendloop As Int16 = 1

        ' exit gracefully if this fails at any time
        Try

            ' set the com port 
            myComport.PortName = arg_comport
            myComport.BaudRate = 9600
            myComport.Parity = IO.Ports.Parity.None
            myComport.StopBits = IO.Ports.StopBits.One


            ' see if we can access the com port
            If myComport.IsOpen = True Then

                ' do nothing

            Else
                ' open the com port
                myComport.Open()

            End If


            ' -- all looking good --

            ' Start the child process as a thread and continue with sending characters on the serial port

            ' start child thread process (listen)
            child_trd = New Thread(AddressOf Child_Thread)
            child_trd.IsBackground = True
            child_trd.Priority = ThreadPriority.Lowest
            child_trd.Start()



            ' -- continue with the parent process --

            ' get the current time
            starttime = New DateTime(Now.Year, Now.Month, Now.Day, Now.Hour, Now.Minute, Now.Second)

            myComport.Write(sendchar)  ' write one character

            ' do until it's not a '1'

            While do_sendloop = 1

                elapsed = DateDiff("s", starttime, Now(), 0, 0)

                If elapsed >= timeout_seconds + 1 Then   ' exit the loop if we're hitting the timeout 
                    do_sendloop = 0                      ' NOTE: the 'listen' process ends one second earlier
                End If

            End While


        Catch ex As Exception

            Console.WriteLine("Parent Process: Could not open com port")

        End Try

        myComport.Close()

    End Sub


End Module
