/*
 * Angles
 *
 * A J2ME application I wrote for my nokia 3270 so I could calculate the
 * distance to an object in the field using compass angles from two points.
 *
 * Author: M. Post
 * Last modified: 13 December 2010
 *
 *
 * Written in Netbeans 6.9.1 (Java-ME version)
 *
 * Using Java SDK, filename: jdk-6u23-windows-i586.exe  (76MB)
 * http://www.oracle.com/technetwork/java/javase/downloads/index.html
 *
 * Nokia SDK: Series 40 5th Edition SDK (Based on Nokia 6267 device)
 * Filename: S40_5th_Edition_SDK_1_0.zip
 *
 * 
 * To get started in J2ME:
 * http://www.roseindia.net/j2me/text-field.shtml
 *
 * A simple introduction to creating a mobile Java application:
 * http://wiki.forum.nokia.com/index.php/NetBeans
 *
 * This project was used to rewrite this program to use a Canvas instead of a Screen
 * http://javalessons.com/cgi-bin/jme/j2me-tutorial-java.cgi?1cd=cnv&sid=ao789&j2ee=jme
 *
 * Word Wrap
 * http://stackoverflow.com/questions/3421070/wrap-text-on-canvas-in-j2me
 *
 * On images in java
 * http://mindprod.com/jgloss/image.html
 *
 * TODO:
 *  - match correct error messages with what's happening
 *  - get error messages displayed properly (word wrap?)
 *  - add support for phones with on-board compass and gps
 *
 *
 */




package angles;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;





/**
 * @author marcel
 */

public class Angles extends MIDlet implements CommandListener {

    private Display dsp;
    private Form fm;
    private Displayable curr;
    private TextField tf1, tf2, tf3, tf4;
    private Command cmdq, cmdcalc ;
    private CusCanvas canv;

    double angle_a=0, angle_b=0, angle_c=0;
    double c_angle_a = 0;
    double c_angle_b = 0;
    double distance_a_c = 0;
    double distance_b_c = 0;
    double distance_a_b;
    double offset = 0;
    int doSplash = 0;
    int errorCode = 0;



    //<editor-fold defaultstate="collapsed" desc=" Generated Fields ">//GEN-BEGIN:|fields|0|
    private Command exitCommand;
    private Command okCommand;
    private Form form;
    //</editor-fold>//GEN-END:|fields|0|

    /**
     * The HelloMIDlet constructor.
     */
    public Angles() {

         fm = new Form("-- Angles --");

         tf1 = new TextField("Angle C from A:", "345", 6, TextField.DECIMAL );
         tf2 = new TextField("Angle C from B:", "300", 6, TextField.DECIMAL );
         tf3 = new TextField("Offset angle B from A:", "90", 6, TextField.DECIMAL );
         tf4 = new TextField("Distance A to B:", "1", 6, TextField.DECIMAL );

         cmdq = new Command("Quit", Command.EXIT, 0);
         cmdcalc = new Command("Calculate", Command.SCREEN, 0);

         fm.append(tf1);
         fm.append(tf2);
         fm.append(tf3);
         fm.append(tf4);

         fm.addCommand(cmdcalc);
         fm.addCommand(cmdq);
         fm.setCommandListener(this);




       
    }

    //<editor-fold defaultstate="collapsed" desc=" Generated Methods ">//GEN-BEGIN:|methods|0|
    //</editor-fold>//GEN-END:|methods|0|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: initialize ">//GEN-BEGIN:|0-initialize|0|0-preInitialize
    /**
     * Initilizes the application.
     * It is called only once when the MIDlet is started. The method is called before the <code>startMIDlet</code> method.
     */
    private void initialize() {//GEN-END:|0-initialize|0|0-preInitialize
        // write pre-initialize user code here
//GEN-LINE:|0-initialize|1|0-postInitialize
        // write post-initialize user code here
    }//GEN-BEGIN:|0-initialize|2|
    //</editor-fold>//GEN-END:|0-initialize|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: startMIDlet ">//GEN-BEGIN:|3-startMIDlet|0|3-preAction
    /**
     * Performs an action assigned to the Mobile Device - MIDlet Started point.
     */
    public void startMIDlet() {//GEN-END:|3-startMIDlet|0|3-preAction
        // write pre-action user code here

        switchDisplayable(null, getForm());//GEN-LINE:|3-startMIDlet|1|3-postAction
        // write post-action user code here
    }//GEN-BEGIN:|3-startMIDlet|2|
    //</editor-fold>//GEN-END:|3-startMIDlet|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: resumeMIDlet ">//GEN-BEGIN:|4-resumeMIDlet|0|4-preAction
    /**
     * Performs an action assigned to the Mobile Device - MIDlet Resumed point.
     */
    public void resumeMIDlet() {//GEN-END:|4-resumeMIDlet|0|4-preAction
        // write pre-action user code here
//GEN-LINE:|4-resumeMIDlet|1|4-postAction
        // write post-action user code here
    }//GEN-BEGIN:|4-resumeMIDlet|2|
    //</editor-fold>//GEN-END:|4-resumeMIDlet|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: switchDisplayable ">//GEN-BEGIN:|5-switchDisplayable|0|5-preSwitch
    /**
     * Switches a current displayable in a display. The <code>display</code> instance is taken from <code>getDisplay</code> method. This method is used by all actions in the design for switching displayable.
     * @param alert the Alert which is temporarily set to the display; if <code>null</code>, then <code>nextDisplayable</code> is set immediately
     * @param nextDisplayable the Displayable to be set
     */
    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {//GEN-END:|5-switchDisplayable|0|5-preSwitch
        // write pre-switch user code here
        Display display = getDisplay();//GEN-BEGIN:|5-switchDisplayable|1|5-postSwitch
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }//GEN-END:|5-switchDisplayable|1|5-postSwitch
        // write post-switch user code here
    }//GEN-BEGIN:|5-switchDisplayable|2|
    //</editor-fold>//GEN-END:|5-switchDisplayable|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: commandAction for Displayables ">//GEN-BEGIN:|7-commandAction|0|7-preCommandAction
    /**
     * Called by a system to indicated that a command has been invoked on a particular displayable.
     * @param command the Command that was invoked
     * @param displayable the Displayable where the command was invoked
     */
    public void commandAction(Command command, Displayable displayable) {//GEN-END:|7-commandAction|0|7-preCommandAction
        // write pre-action user code here

        if (command == cmdq){
          notifyDestroyed();
          return;
        }
        calc();
        if (canv==null) canv= new CusCanvas() ;
        curr=canv;
        dsp.setCurrent(canv);



        if (displayable == form) {//GEN-BEGIN:|7-commandAction|1|19-preAction
            if (command == exitCommand) {//GEN-END:|7-commandAction|1|19-preAction
                // write pre-action user code here
                exitMIDlet();//GEN-LINE:|7-commandAction|2|19-postAction
                // write post-action user code here
            } else if (command == okCommand) {//GEN-LINE:|7-commandAction|3|23-preAction
                // write pre-action user code here
//GEN-LINE:|7-commandAction|4|23-postAction
              
            }//GEN-BEGIN:|7-commandAction|5|7-postCommandAction
        }//GEN-END:|7-commandAction|5|7-postCommandAction
        // write post-action user code here
    }//GEN-BEGIN:|7-commandAction|6|
    //</editor-fold>//GEN-END:|7-commandAction|6|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: exitCommand ">//GEN-BEGIN:|18-getter|0|18-preInit
    /**
     * Returns an initiliazed instance of exitCommand component.
     * @return the initialized component instance
     */
    public Command getExitCommand() {
        if (exitCommand == null) {//GEN-END:|18-getter|0|18-preInit
            // write pre-init user code here
            exitCommand = new Command("Exit", Command.EXIT, 0);//GEN-LINE:|18-getter|1|18-postInit
            // write post-init user code here
        }//GEN-BEGIN:|18-getter|2|
        return exitCommand;
    }
    //</editor-fold>//GEN-END:|18-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: form ">//GEN-BEGIN:|14-getter|0|14-preInit
    /**
     * Returns an initiliazed instance of form component.
     * @return the initialized component instance
     */
    public Form getForm() {
        if (form == null) {//GEN-END:|14-getter|0|14-preInit
            // write pre-init user code here

           
            form = new Form("-- Angle Calculator --", new Item[] { });//GEN-BEGIN:|14-getter|1|14-postInit
            form.addCommand(getExitCommand());
            form.addCommand(getOkCommand());
            form.setCommandListener(this);//GEN-END:|14-getter|1|14-postInit
            // write post-init user code here

        }//GEN-BEGIN:|14-getter|2|
        return form;
    }
    //</editor-fold>//GEN-END:|14-getter|2|



    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: okCommand ">//GEN-BEGIN:|22-getter|0|22-preInit
    /**
     * Returns an initiliazed instance of okCommand component.
     * @return the initialized component instance
     */
    public Command getOkCommand() {
        if (okCommand == null) {//GEN-END:|22-getter|0|22-preInit
            // write pre-init user code here
            okCommand = new Command("Ok", Command.OK, 0);//GEN-LINE:|22-getter|1|22-postInit
            // write post-init user code here
        }//GEN-BEGIN:|22-getter|2|
        return okCommand;
    }
    //</editor-fold>//GEN-END:|22-getter|2|

    

    private void calc()
    {

      try {

        
        
        distance_a_b = Double.parseDouble(tf4.getString());

        double sin_a = 0;
        double sin_b = 0;

        int frontmeasure = 0;
        int backmeasure = 0;

        // calculate inner angles a and b
        // bring angle back to zero

        angle_a = Double.parseDouble(tf1.getString());
        angle_b = Double.parseDouble(tf2.getString());
        offset = Double.parseDouble(tf3.getString());


        c_angle_a = angle_a;
        c_angle_b = angle_b;

        if (c_angle_a == 360) { c_angle_a = 0; }
        if (c_angle_b == 360) { c_angle_b = 0; }
        if (offset == 360) { offset = 0; }
        
        doSplash=0;

        // test if we're measuring in front or behind

        // when the offset angle is 180 - 360
        if ((offset < 360) && (offset > 180))
        {
           
            // check compass angle a
            if (((c_angle_a > offset) && (c_angle_a < 360)) || ((c_angle_a >= 0) && (c_angle_a < (offset - 180))))
            {
                // if angle a falls in either of these ranges it's a valid front measure


                if ((c_angle_a > offset) && (c_angle_a < 360))
                {
                    angle_a = c_angle_a - offset; // ok
                    frontmeasure = frontmeasure + 1;

                }
                if ((c_angle_a >= 0) && (c_angle_a < (offset - 180)))
                {
                    angle_a = (360 - offset) + c_angle_a; // ok
                    frontmeasure = frontmeasure + 1;
                }
                
            }

            if ((c_angle_a < offset) && (c_angle_a > (offset-180)))
            {
                // if angle a falls in either of these ranges it's a valid back measure
                angle_a = offset - c_angle_a; // ok
                backmeasure = backmeasure + 1;
            }

            // check compass angle b
            if (((c_angle_b > offset) && (c_angle_b < 360)) || ((c_angle_b >= 0) && (c_angle_b < (offset - 180))))
            {
                // if angle b falls in either of these ranges it's a valid front measure
                

                if ((c_angle_b > offset) && (c_angle_b < 360))
                {                   
                    angle_b = offset - (c_angle_b - 180); // ok
                    frontmeasure = frontmeasure + 1;
                }
                if ((c_angle_b >= 0) && (c_angle_b < (offset - 180)))
                {
                    angle_b = (offset - 180) - c_angle_b; // ok
                    frontmeasure = frontmeasure + 1;
                }
               
            }

            if ((c_angle_b > (offset-180)) && (c_angle_b < offset))
            {
                // if angle b falls in either of these ranges it's a valid back measure
                angle_b = 180 - (offset - c_angle_b); // ok
                backmeasure = backmeasure + 1;
            }

         

        }

        // when the offset angle is 0 - 180
        if ((offset >= 0) && (offset <= 180))
        {

            // check compass angle a
            if (((c_angle_a > (180 + offset)) && (c_angle_a < 360)) || ((c_angle_a >= 0) && (c_angle_a < offset)))
            {
                // if angle a falls in either of these ranges it's a valid back measure
  
                if ((c_angle_a > (180 + offset)) && (c_angle_a < 360))
                {
                    angle_a = 360-(c_angle_a - offset);  // ok
                    backmeasure = backmeasure + 1;
                }

                if ((c_angle_a >= 0) && (c_angle_a < offset))
                {                   
                    angle_a = offset - c_angle_a ;  // ok
                    backmeasure = backmeasure + 1;
                }

            }

            if ((c_angle_a > offset) && (c_angle_a < 180 + offset))
            {
                // if angle a falls in either of these ranges it's a valid front measure
                angle_a = c_angle_a - offset; // ok
                frontmeasure = frontmeasure + 1;
            }



            // check compass angle b
            if (((c_angle_b > (180 + offset)) && (c_angle_b < 360)) || ((c_angle_b >= 0) && (c_angle_b < (180 + offset))))
            {
                // if angle b falls in either of these ranges it's a valid back measure

                if ((c_angle_b > (180 + offset)) && (c_angle_b < 360))
                {
                    angle_b = (c_angle_b - 180) - offset;  // ok
                    backmeasure = backmeasure + 1;
                }

                if ((c_angle_b >= 0) && (c_angle_b < (180 + offset)))
                {
                    angle_b = (180 - offset) + c_angle_b;  // ok
                    backmeasure = backmeasure + 1;
                }

            }
            if ((c_angle_b > offset) && (c_angle_b < 180 + offset))
            {
                // if angle b falls in either of these ranges it's a valid front measure

                angle_b = (180 - c_angle_b) + offset; // ok
                frontmeasure = frontmeasure + 1;
            }

        }


        // calculate angle c
        angle_c = 180 - angle_a - angle_b;

        if ((frontmeasure == 2) || (backmeasure == 2))
        {
            errorCode = 0;
        } else {
            errorCode = 1;
        }


        if (angle_a <= 0 || angle_a > 360)  { errorCode = 2; }
        if (angle_b <= 0 || angle_b > 360)  { errorCode = 3; }
        if (angle_c <= 0 || angle_b > 360)  { errorCode = 4; }
        if (distance_a_b <= 0) { errorCode = 5; }


        if (errorCode == 0)
        {

            // angles look okay, calculate distances

            angle_c = 180 - angle_a - angle_b;

            // round all angles to two decimals
            angle_a = (double) (int) ((angle_a+0.005)*100.0)/100.0;
            angle_b = (double) (int) ((angle_b+0.005)*100.0)/100.0;
            angle_c = (double) (int) ((angle_c+0.005)*100.0)/100.0;



            // calculate the constant (for the triangle abc) sin(C) value
            double sin_c_angle_const = (Math.sin(Math.toRadians(angle_c)) / distance_a_b);


            // calculate sin(A)
            sin_a = Math.sin(Math.toRadians(angle_a));
        
            // calculate sin(B)
            sin_b = Math.sin(Math.toRadians(angle_b));


            // calculate the distance from A to C
            distance_a_c = sin_b / sin_c_angle_const;
            // round number to two decimals
            distance_a_c = (double) (int) ((distance_a_c+0.005)*100.0)/100.0;


            // calculate the distance from B to C
            distance_b_c = sin_a / sin_c_angle_const;
            // round number to two decimals
            distance_b_c = (double) (int) ((distance_b_c+0.005)*100.0)/100.0;



            // a little easter egg

            if ((c_angle_a==25.25) && (c_angle_b==12.12))
            {
                doSplash=1;
            }


        } else {
            // compass angles entered are incorrect

            //showErrorScreen(errorCode);

            angle_a = 0;
            angle_b = 0;
            angle_c = 0;
            distance_a_c = 0;
            distance_b_c = 0;

        }


      } catch (NumberFormatException e) {
            //sitres.setText("unknown");
            // e.printStackTrace();
      }

    }

    /**
     * Returns a display instance.
     * @return the display instance.
     */
    public Display getDisplay ()
    {
        return Display.getDisplay(this);
    }

    /**
     * Exits MIDlet.
     */
    public void exitMIDlet()
    {
        switchDisplayable (null, null);
        destroyApp(true);
        notifyDestroyed();
    }

    /**
     * Called when MIDlet is started.
     * Checks whether the MIDlet have been already started and initialize/starts or resumes the MIDlet.
     */
    public void startApp()
    {
        dsp=Display.getDisplay(this);
        if (curr!=null)
            dsp.setCurrent(curr);
        else
        {
            dsp.setCurrent(fm);
            curr=fm;
        }
    }


    /**
     * Called when MIDlet is paused.
     */
    public void pauseApp() {
        //midletPaused = true;
    }

    /**
     * Called to signal the MIDlet to terminate.
     * @param unconditional if true, then the MIDlet has to be unconditionally terminated and all resources has to be released.
     */
    public void destroyApp(boolean unconditional) {
    }





    class CusCanvas extends Canvas implements CommandListener
    {


      CusCanvas()
      {
        this.addCommand( new Command("Back", Command.BACK, 0 ) );
        this.setCommandListener(this);
      }

      protected void paint(Graphics g)
      {

        int w = getWidth();   // 240
        int h = getHeight();  // 248


      
        if (errorCode == 0)
        {

            if (doSplash==1)
            {
                //show splash image (max size w*h = 240x248)

                try {
                        
                    Image splash = Image.createImage(w, h);

                    // image path is: ../NetBeansProjects/Angles/src/res/splash.jpg
                    splash = Image.createImage("/res/splash.jpg");
                    g.drawImage(splash, 0, 0, Graphics.LEFT | Graphics.TOP);

                 } catch (IOException ex) {

                    g.setColor(0);  // black
                    g.drawString("Failed to load image!", 5, h/2, Graphics.TOP | Graphics.LEFT);
                    return;
                 }
        
          } else {

                // show results page with triangle in a circle

                int offsetdown = 0;
                int r = 0;  // max radius from center

                int midx = 0;
                int midy = 0;

                int b_x = 0;
                int b_y = 0;
                int c_x = 0;
                int c_y = 0;


                g.setGrayScale(255); // white
                g.fillRect( 0,0,w,h ); // set background colour

                g.setGrayScale(0);  // black
                g.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_PLAIN, Font.SIZE_MEDIUM));
                g.drawString("Distance A to C: "+distance_a_c, 5, 18,   Graphics.BASELINE|Graphics.LEFT);
                g.drawString("Distance B to C: "+distance_b_c, 5, 36,   Graphics.BASELINE|Graphics.LEFT);


                // draw circle so we know where our midpoint should be
                offsetdown = 14;
                r = (w/2)-offsetdown-15;  // max radius from center
                g.setGrayScale(14*16);  // light grey
                g.drawArc((w/2)-r,((h-(2*r))/2)+offsetdown,(2*r),(2*r), 0, 360);

                // define midpoint for circle centre
                midx = (w/2);
                midy = (h/2)+offsetdown;

            
                g.setGrayScale(0);  // black

                // draw triangle

                // determine which line is longest A-C or B-C or A-B

                if ((distance_a_b > distance_a_c) && (distance_a_b > distance_b_c))
                {
                    // distance_ab is longest

                
                    // determine the coordinates on the screen for point B
                    b_x = (int) ((Math.sin(Math.toRadians(offset))) * r);
                    b_y = (int) ((Math.cos(Math.toRadians(offset))) * r);

                    // draw the line from A to B
                    g.drawLine(midx,midy,midx+b_x,midy-b_y);

                    // determine the coordinates on the screen for point C
                    c_x = (int) ((Math.sin(Math.toRadians(c_angle_a))) * ((distance_a_c/distance_a_b)*r));
                    c_y = (int) ((Math.cos(Math.toRadians(c_angle_a))) * ((distance_a_c/distance_a_b)*r));

                    // draw the line from A to C
                    g.drawLine(midx,midy,midx+c_x,midy-c_y);

                    // draw the line from B to C
                    g.drawLine(midx+b_x,midy-b_y,midx+c_x,midy-c_y);

                } else {

                    if (distance_a_c > distance_b_c)
                    {
                        // distance_a_c is longest

                        // determine the coordinates on the screen for point C
                        c_x = (int) ((Math.sin(Math.toRadians(c_angle_a))) * r);
                        c_y = (int) ((Math.cos(Math.toRadians(c_angle_a))) * r);

                        // draw the line from A to C
                        g.drawLine(midx,midy,midx+c_x,midy-c_y);

                        // determine the coordinates on the screen for point B
                        b_x = (int) ((Math.sin(Math.toRadians(offset))) * ((distance_a_b/distance_a_c)*r));
                        b_y = (int) ((Math.cos(Math.toRadians(offset))) * ((distance_a_b/distance_a_c)*r));

                        // draw the line from A to B
                        g.drawLine(midx,midy,midx+b_x,midy-b_y);

                        // draw the line from B to C
                        g.drawLine(midx+b_x,midy-b_y,midx+c_x,midy-c_y);

                    } else {

                        // distance_b_c is longest

                        // determine whether A-C or A-B will be r length

                        if (distance_a_c > distance_a_b)
                        {
                          // -- A-C will be r length --

                          // determine the coordinates on the screen for point C

                          c_x = (int) ((Math.sin(Math.toRadians(c_angle_a))) * r);
                          c_y = (int) ((Math.cos(Math.toRadians(c_angle_a))) * r);

                          // draw the line from A to C
                          g.drawLine(midx,midy,midx+c_x,midy-c_y);

                          // determine the coordinates on the screen for point B
                          b_x = (int) ((Math.sin(Math.toRadians(offset))) * ((distance_a_b/distance_a_c)*r));
                          b_y = (int) ((Math.cos(Math.toRadians(offset))) * ((distance_a_b/distance_a_c)*r));

                          // draw the line from A to B
                          g.drawLine(midx,midy,midx+b_x,midy-b_y);

                          // draw the line from B to C
                          g.drawLine(midx+b_x,midy-b_y,midx+c_x,midy-c_y);

                      } else {

                          // -- A-B will be r length --

                          // determine the coordinates on the screen for point B

                          b_x = (int) ((Math.sin(Math.toRadians(offset))) * r);
                          b_y = (int) ((Math.cos(Math.toRadians(offset))) * r);

                          // draw the line from A to B
                          g.drawLine(midx,midy,midx+b_x,midy-b_y);


                          // determine the coordinates on the screen for point C
                          c_x = (int) ((Math.sin(Math.toRadians(c_angle_a))) * ((distance_a_c/distance_a_b)*r));
                          c_y = (int) ((Math.cos(Math.toRadians(c_angle_a))) * ((distance_a_c/distance_a_b)*r));

                          // draw the line from A to C
                          g.drawLine(midx,midy,midx+c_x,midy-c_y);

                          // draw the line from B to C
                          g.drawLine(midx+b_x,midy-b_y,midx+c_x,midy-c_y);

                        }

                    }

                }

                // display corner letters and distances

                g.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_SMALL));
                g.setGrayScale(11*16);  // light grey
                g.drawString("A", midx+5, midy, Graphics.BASELINE|Graphics.LEFT);
                g.drawString("B", midx+b_x+5, midy-b_y, Graphics.BASELINE|Graphics.LEFT);
                g.drawString("C", midx+c_x+5, midy-c_y, Graphics.BASELINE|Graphics.LEFT);


                g.setGrayScale(0);  // black
                g.drawString("A:"+angle_a, 2, 245,  Graphics.BASELINE|Graphics.LEFT);
                g.drawString("B:"+angle_b, 95, 245,  Graphics.BASELINE|Graphics.LEFT);
                g.drawString("C:"+angle_c, 178, 245,  Graphics.BASELINE|Graphics.LEFT);

            } // end of result display screen

            // end no errors function
            
        } else {

            // error(s) encountered

            g.setColor(200,100,100); // red
            g.fillRect( 0,0,w,h ); // set background colour


            String errorText = "error";

            if (errorCode==1)
            {
                errorText = "Compass angles entered don't converge in the same direction! Please try again.";
            }
            if (errorCode==2)
            {
                errorText = "Compass angle A is out of range! Please try again.";
            }
            if (errorCode==3)
            {
                errorText = "Compass angle B is out of range! Please try again.";
            }
            if (errorCode==4)
            {
                errorText = "Compass angle C is out of range! Please try again.";
            }
            if (errorCode==5)
            {
                errorText = "No valid distance between point A and B given! Please try again.";
            }


            g.setGrayScale(0);  // black text
            
            g.drawString("Error!", w/2, (h/2)-60,  Graphics.TOP|Graphics.HCENTER);
            g.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_SMALL));
            // do word wrap
            g.drawString(errorText, 0, h/2,  Graphics.BASELINE|Graphics.LEFT);

        }

      } // end paint function


      public void commandAction( Command c, Displayable d)
      {
        curr=fm;
        dsp.setCurrent(fm);
      }

    } // end CusCanvas class


  

  } // end Angles class


