/*
 * Decompiled with CFR 0.152.
 */
package angles;

import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Angles
extends MIDlet
implements CommandListener {
    private Display dsp;
    private Form fm = new Form("-- Angles --");
    private Displayable curr;
    private TextField tf1 = new TextField("Angle C from A:", "345", 6, 5);
    private TextField tf2 = new TextField("Angle C from B:", "300", 6, 5);
    private TextField tf3 = new TextField("Offset angle B from A:", "90", 6, 5);
    private TextField tf4 = new TextField("Distance A to B:", "1", 6, 5);
    private Command cmdq = new Command("Quit", 7, 0);
    private Command cmdcalc = new Command("Calculate", 1, 0);
    private CusCanvas canv;
    double angle_a = 0.0;
    double angle_b = 0.0;
    double angle_c = 0.0;
    double c_angle_a = 0.0;
    double c_angle_b = 0.0;
    double distance_a_c = 0.0;
    double distance_b_c = 0.0;
    double distance_a_b;
    double offset = 0.0;
    int doSplash = 0;
    int errorCode = 0;
    private Command exitCommand;
    private Command okCommand;
    private Form form;

    public Angles() {
        this.fm.append((Item)this.tf1);
        this.fm.append((Item)this.tf2);
        this.fm.append((Item)this.tf3);
        this.fm.append((Item)this.tf4);
        this.fm.addCommand(this.cmdcalc);
        this.fm.addCommand(this.cmdq);
        this.fm.setCommandListener((CommandListener)this);
    }

    private void initialize() {
    }

    public void startMIDlet() {
        this.switchDisplayable(null, (Displayable)this.getForm());
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdq) {
            this.notifyDestroyed();
            return;
        }
        this.calc();
        if (this.canv == null) {
            this.canv = new CusCanvas();
        }
        this.curr = this.canv;
        this.dsp.setCurrent((Displayable)this.canv);
        if (displayable == this.form) {
            if (command == this.exitCommand) {
                this.exitMIDlet();
            } else if (command == this.okCommand) {
                // empty if block
            }
        }
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 0);
        }
        return this.exitCommand;
    }

    public Form getForm() {
        if (this.form == null) {
            this.form = new Form("-- Angle Calculator --", new Item[0]);
            this.form.addCommand(this.getExitCommand());
            this.form.addCommand(this.getOkCommand());
            this.form.setCommandListener((CommandListener)this);
        }
        return this.form;
    }

    public Command getOkCommand() {
        if (this.okCommand == null) {
            this.okCommand = new Command("Ok", 4, 0);
        }
        return this.okCommand;
    }

    private void calc() {
        try {
            this.distance_a_b = Double.parseDouble(this.tf4.getString());
            double sin_a = 0.0;
            double sin_b = 0.0;
            int frontmeasure = 0;
            int backmeasure = 0;
            this.angle_a = Double.parseDouble(this.tf1.getString());
            this.angle_b = Double.parseDouble(this.tf2.getString());
            this.offset = Double.parseDouble(this.tf3.getString());
            this.c_angle_a = this.angle_a;
            this.c_angle_b = this.angle_b;
            if (this.c_angle_a == 360.0) {
                this.c_angle_a = 0.0;
            }
            if (this.c_angle_b == 360.0) {
                this.c_angle_b = 0.0;
            }
            if (this.offset == 360.0) {
                this.offset = 0.0;
            }
            this.doSplash = 0;
            if (this.offset < 360.0 && this.offset > 180.0) {
                if (this.c_angle_a > this.offset && this.c_angle_a < 360.0 || this.c_angle_a >= 0.0 && this.c_angle_a < this.offset - 180.0) {
                    if (this.c_angle_a > this.offset && this.c_angle_a < 360.0) {
                        this.angle_a = this.c_angle_a - this.offset;
                        ++frontmeasure;
                    }
                    if (this.c_angle_a >= 0.0 && this.c_angle_a < this.offset - 180.0) {
                        this.angle_a = 360.0 - this.offset + this.c_angle_a;
                        ++frontmeasure;
                    }
                }
                if (this.c_angle_a < this.offset && this.c_angle_a > this.offset - 180.0) {
                    this.angle_a = this.offset - this.c_angle_a;
                    ++backmeasure;
                }
                if (this.c_angle_b > this.offset && this.c_angle_b < 360.0 || this.c_angle_b >= 0.0 && this.c_angle_b < this.offset - 180.0) {
                    if (this.c_angle_b > this.offset && this.c_angle_b < 360.0) {
                        this.angle_b = this.offset - (this.c_angle_b - 180.0);
                        ++frontmeasure;
                    }
                    if (this.c_angle_b >= 0.0 && this.c_angle_b < this.offset - 180.0) {
                        this.angle_b = this.offset - 180.0 - this.c_angle_b;
                        ++frontmeasure;
                    }
                }
                if (this.c_angle_b > this.offset - 180.0 && this.c_angle_b < this.offset) {
                    this.angle_b = 180.0 - (this.offset - this.c_angle_b);
                    ++backmeasure;
                }
            }
            if (this.offset >= 0.0 && this.offset <= 180.0) {
                if (this.c_angle_a > 180.0 + this.offset && this.c_angle_a < 360.0 || this.c_angle_a >= 0.0 && this.c_angle_a < this.offset) {
                    if (this.c_angle_a > 180.0 + this.offset && this.c_angle_a < 360.0) {
                        this.angle_a = 360.0 - (this.c_angle_a - this.offset);
                        ++backmeasure;
                    }
                    if (this.c_angle_a >= 0.0 && this.c_angle_a < this.offset) {
                        this.angle_a = this.offset - this.c_angle_a;
                        ++backmeasure;
                    }
                }
                if (this.c_angle_a > this.offset && this.c_angle_a < 180.0 + this.offset) {
                    this.angle_a = this.c_angle_a - this.offset;
                    ++frontmeasure;
                }
                if (this.c_angle_b > 180.0 + this.offset && this.c_angle_b < 360.0 || this.c_angle_b >= 0.0 && this.c_angle_b < 180.0 + this.offset) {
                    if (this.c_angle_b > 180.0 + this.offset && this.c_angle_b < 360.0) {
                        this.angle_b = this.c_angle_b - 180.0 - this.offset;
                        ++backmeasure;
                    }
                    if (this.c_angle_b >= 0.0 && this.c_angle_b < 180.0 + this.offset) {
                        this.angle_b = 180.0 - this.offset + this.c_angle_b;
                        ++backmeasure;
                    }
                }
                if (this.c_angle_b > this.offset && this.c_angle_b < 180.0 + this.offset) {
                    this.angle_b = 180.0 - this.c_angle_b + this.offset;
                    ++frontmeasure;
                }
            }
            this.angle_c = 180.0 - this.angle_a - this.angle_b;
            this.errorCode = frontmeasure == 2 || backmeasure == 2 ? 0 : 1;
            if (this.angle_a <= 0.0 || this.angle_a > 360.0) {
                this.errorCode = 2;
            }
            if (this.angle_b <= 0.0 || this.angle_b > 360.0) {
                this.errorCode = 3;
            }
            if (this.angle_c <= 0.0 || this.angle_b > 360.0) {
                this.errorCode = 4;
            }
            if (this.distance_a_b <= 0.0) {
                this.errorCode = 5;
            }
            if (this.errorCode == 0) {
                this.angle_c = 180.0 - this.angle_a - this.angle_b;
                this.angle_a = (double)((int)((this.angle_a + 0.005) * 100.0)) / 100.0;
                this.angle_b = (double)((int)((this.angle_b + 0.005) * 100.0)) / 100.0;
                this.angle_c = (double)((int)((this.angle_c + 0.005) * 100.0)) / 100.0;
                double sin_c_angle_const = Math.sin(Math.toRadians(this.angle_c)) / this.distance_a_b;
                sin_a = Math.sin(Math.toRadians(this.angle_a));
                sin_b = Math.sin(Math.toRadians(this.angle_b));
                this.distance_a_c = sin_b / sin_c_angle_const;
                this.distance_a_c = (double)((int)((this.distance_a_c + 0.005) * 100.0)) / 100.0;
                this.distance_b_c = sin_a / sin_c_angle_const;
                this.distance_b_c = (double)((int)((this.distance_b_c + 0.005) * 100.0)) / 100.0;
                if (this.c_angle_a == 25.25 && this.c_angle_b == 12.12) {
                    this.doSplash = 1;
                }
            } else {
                this.angle_a = 0.0;
                this.angle_b = 0.0;
                this.angle_c = 0.0;
                this.distance_a_c = 0.0;
                this.distance_b_c = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        this.dsp = Display.getDisplay((MIDlet)this);
        if (this.curr != null) {
            this.dsp.setCurrent(this.curr);
        } else {
            this.dsp.setCurrent((Displayable)this.fm);
            this.curr = this.fm;
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    class CusCanvas
    extends Canvas
    implements CommandListener {
        CusCanvas() {
            this.addCommand(new Command("Back", 2, 0));
            this.setCommandListener(this);
        }

        protected void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (Angles.this.errorCode == 0) {
                if (Angles.this.doSplash == 1) {
                    try {
                        Image splash = Image.createImage((int)w, (int)h);
                        splash = Image.createImage((String)"/res/splash.jpg");
                        g.drawImage(splash, 0, 0, 20);
                    }
                    catch (IOException ex) {
                        g.setColor(0);
                        g.drawString("Failed to load image!", 5, h / 2, 20);
                        return;
                    }
                } else {
                    int offsetdown = 0;
                    int r = 0;
                    int midx = 0;
                    int midy = 0;
                    int b_x = 0;
                    int b_y = 0;
                    int c_x = 0;
                    int c_y = 0;
                    g.setGrayScale(255);
                    g.fillRect(0, 0, w, h);
                    g.setGrayScale(0);
                    g.setFont(Font.getFont((int)64, (int)0, (int)0));
                    g.drawString("Distance A to C: " + Angles.this.distance_a_c, 5, 18, 68);
                    g.drawString("Distance B to C: " + Angles.this.distance_b_c, 5, 36, 68);
                    offsetdown = 14;
                    r = w / 2 - offsetdown - 15;
                    g.setGrayScale(224);
                    g.drawArc(w / 2 - r, (h - 2 * r) / 2 + offsetdown, 2 * r, 2 * r, 0, 360);
                    midx = w / 2;
                    midy = h / 2 + offsetdown;
                    g.setGrayScale(0);
                    if (Angles.this.distance_a_b > Angles.this.distance_a_c && Angles.this.distance_a_b > Angles.this.distance_b_c) {
                        b_x = (int)(Math.sin(Math.toRadians(Angles.this.offset)) * (double)r);
                        b_y = (int)(Math.cos(Math.toRadians(Angles.this.offset)) * (double)r);
                        g.drawLine(midx, midy, midx + b_x, midy - b_y);
                        c_x = (int)(Math.sin(Math.toRadians(Angles.this.c_angle_a)) * (Angles.this.distance_a_c / Angles.this.distance_a_b * (double)r));
                        c_y = (int)(Math.cos(Math.toRadians(Angles.this.c_angle_a)) * (Angles.this.distance_a_c / Angles.this.distance_a_b * (double)r));
                        g.drawLine(midx, midy, midx + c_x, midy - c_y);
                        g.drawLine(midx + b_x, midy - b_y, midx + c_x, midy - c_y);
                    } else if (Angles.this.distance_a_c > Angles.this.distance_b_c) {
                        c_x = (int)(Math.sin(Math.toRadians(Angles.this.c_angle_a)) * (double)r);
                        c_y = (int)(Math.cos(Math.toRadians(Angles.this.c_angle_a)) * (double)r);
                        g.drawLine(midx, midy, midx + c_x, midy - c_y);
                        b_x = (int)(Math.sin(Math.toRadians(Angles.this.offset)) * (Angles.this.distance_a_b / Angles.this.distance_a_c * (double)r));
                        b_y = (int)(Math.cos(Math.toRadians(Angles.this.offset)) * (Angles.this.distance_a_b / Angles.this.distance_a_c * (double)r));
                        g.drawLine(midx, midy, midx + b_x, midy - b_y);
                        g.drawLine(midx + b_x, midy - b_y, midx + c_x, midy - c_y);
                    } else if (Angles.this.distance_a_c > Angles.this.distance_a_b) {
                        c_x = (int)(Math.sin(Math.toRadians(Angles.this.c_angle_a)) * (double)r);
                        c_y = (int)(Math.cos(Math.toRadians(Angles.this.c_angle_a)) * (double)r);
                        g.drawLine(midx, midy, midx + c_x, midy - c_y);
                        b_x = (int)(Math.sin(Math.toRadians(Angles.this.offset)) * (Angles.this.distance_a_b / Angles.this.distance_a_c * (double)r));
                        b_y = (int)(Math.cos(Math.toRadians(Angles.this.offset)) * (Angles.this.distance_a_b / Angles.this.distance_a_c * (double)r));
                        g.drawLine(midx, midy, midx + b_x, midy - b_y);
                        g.drawLine(midx + b_x, midy - b_y, midx + c_x, midy - c_y);
                    } else {
                        b_x = (int)(Math.sin(Math.toRadians(Angles.this.offset)) * (double)r);
                        b_y = (int)(Math.cos(Math.toRadians(Angles.this.offset)) * (double)r);
                        g.drawLine(midx, midy, midx + b_x, midy - b_y);
                        c_x = (int)(Math.sin(Math.toRadians(Angles.this.c_angle_a)) * (Angles.this.distance_a_c / Angles.this.distance_a_b * (double)r));
                        c_y = (int)(Math.cos(Math.toRadians(Angles.this.c_angle_a)) * (Angles.this.distance_a_c / Angles.this.distance_a_b * (double)r));
                        g.drawLine(midx, midy, midx + c_x, midy - c_y);
                        g.drawLine(midx + b_x, midy - b_y, midx + c_x, midy - c_y);
                    }
                    g.setFont(Font.getFont((int)64, (int)1, (int)8));
                    g.setGrayScale(176);
                    g.drawString("A", midx + 5, midy, 68);
                    g.drawString("B", midx + b_x + 5, midy - b_y, 68);
                    g.drawString("C", midx + c_x + 5, midy - c_y, 68);
                    g.setGrayScale(0);
                    g.drawString("A:" + Angles.this.angle_a, 2, 245, 68);
                    g.drawString("B:" + Angles.this.angle_b, 95, 245, 68);
                    g.drawString("C:" + Angles.this.angle_c, 178, 245, 68);
                }
            } else {
                g.setColor(200, 100, 100);
                g.fillRect(0, 0, w, h);
                String errorText = "error";
                if (Angles.this.errorCode == 1) {
                    errorText = "Compass angles entered don't converge in the same direction! Please try again.";
                }
                if (Angles.this.errorCode == 2) {
                    errorText = "Compass angle A is out of range! Please try again.";
                }
                if (Angles.this.errorCode == 3) {
                    errorText = "Compass angle B is out of range! Please try again.";
                }
                if (Angles.this.errorCode == 4) {
                    errorText = "Compass angle C is out of range! Please try again.";
                }
                if (Angles.this.errorCode == 5) {
                    errorText = "No valid distance between point A and B given! Please try again.";
                }
                g.setGrayScale(0);
                g.drawString("Error!", w / 2, h / 2 - 60, 17);
                g.setFont(Font.getFont((int)64, (int)1, (int)8));
                g.drawString(errorText, 0, h / 2, 68);
            }
        }

        public void commandAction(Command c, Displayable d) {
            Angles.this.curr = (Displayable)Angles.this.fm;
            Angles.this.dsp.setCurrent((Displayable)Angles.this.fm);
        }
    }
}

