@echo off

set PROJECT=lcd-i2c
set SPEED=8000000UL

set PORT=\\.\USBSER000
REM set PORT=\\.\COM20

set GCC_DEVICE=attiny85
set PGM_DEVICE=t85
set PGM_PROTO=avrispv2
set GCC_OPTIMISATION=-Os

REM GCC_OPTIMISATION="-O2"

echo compile program
avr-gcc -g %GCC_OPTIMISATION% -Wall -mcall-prologues -DF_CPU=%SPEED% -mmcu=%GCC_DEVICE%   -c -o %PROJECT%.o %PROJECT%.c

echo create object file
avr-gcc -g %GCC_OPTIMISATION% -Wall -mcall-prologues -DF_CPU=%SPEED% -mmcu=%GCC_DEVICE% %PROJECT%.o -o %PROJECT%.obj

echo convert object file to hex file
avr-objcopy  -R .eeprom -O ihex %PROJECT%.obj %PROJECT%.hex

echo erase chip
avrdude -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -e


REM Writing 0xE2 to the Fuse Low Byte disables the CKDIV8 (use 0x62 for 1MHz)
REM Writing 0xE1 to the Fuse Low Byte to use internal PLL to run at 16MHz
REM you only need to do this once
rem avrdude -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -U flash:w:%PROJECT%.hex  -U lfuse:w:0xE1:m


echo write program to chip

avrdude -F -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -U flash:w:%PROJECT%.hex  


REM ping localhost -n 5 > nul

pause