/* 
 *  Gettemps
 *
 *  Sends a character to the serial port and displays the received
 *  output on screen. The listening process stops When the received
 *  data contains just the word 'Ok' on a single line.
 *
 *  Syntax: gettemps <port> 
 *
 *  Author: M. Post
 *  Last modified: 6 August 2011
 *

    compile command: g++ <file.c> -o <binaryfile>

 */

#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */
#include <iostream>  // so we can use cout and endl
#include <signal.h>  // so we can trap SIGINT
#include <fstream>
#include <sstream>
#include <sys/time.h>
#include <cstdlib>  // without this malloc error happens on silica


using namespace std;


// defining global variables
string app_version = "1.0";
int fd;                               // File descriptor for the port
FILE *fd_logfile;                     // File descriptor for the file
string str_comport = "/dev/ttyUSB0";  // default port value
string str_logfile;
int logtofile = 0;
int fork_return;
int child_pid;
double listen_timeout = 7000;

struct termios tio;

extern void trapped(int)
{

  // do this when a SIGINT (e.g. CTRL-C) is detected

  // close the port properly
  close(fd);

  cout << endl;

  // kill the program

  // reset the SIGINT behaviour to default
  signal(SIGINT, SIG_DFL);

  // then send a kill to the PID of the process
  kill(getpid(),SIGINT);

}

int open_port(char *comport)
{

   fd = open(comport, O_RDWR | O_NOCTTY | O_NDELAY);

   if (fd == -1)
   {

     /*
      * Could not open the port.
      */

     fputs("open_port: Unable to open port ", stderr);
     fputs(comport, stderr);
     perror(" ");

     return -1;

   } else {
   
     // -- set port control --
     // see: http://tldp.org/HOWTO/Serial-HOWTO.html
     // see: http://frank.harvard.edu/~coldwell/terminals/
     
     // open port at 9600 baud
     long baud;
     baud = B9600;

     tio.c_cflag = baud | CS8 | CREAD | CLOCAL; 
     tcsetattr(fd, TCSANOW, &tio);   // apply the attributes


     fcntl(fd, F_SETFL, 0);    // default blocking behaviour
     // disable (default) blocking behaviour on reads
     // with FNDELAY the read() command will output 0 
     // if no data on the port is available and a 1 if it is.
     //fcntl(fd, F_SETFL, FNDELAY);


     // see if we can write something to the port
   
     int n = 0;

     n = write(fd, "ATZ\r", 4);
     if (n < 0)
     {
       // read ok, write failed
 
       return 1;

     } else {

       // read + write ok
       
       return 2;
       
     }

   }

}

int main(int argc, char *argv[])
{

  // trap the SIGINT so we can properly close the port before terminating
  signal(SIGINT, trapped);


  // define variables
  int open_port_result = 0;           
  int bufferstatus = 0;             // result of reading the port buffer
  char *char_comport;               // char as pointer to char_comport
  char* buf = (char*)malloc(128);   // read buffer size
  string arg1;

  // get and set port from the command line if provided
  if ( argc > 1 )
  {
    arg1 = argv[1];

    if (arg1 == "--help")
    {
      cout << "Syntax: gettemps [port]" << endl;
      cout <<  endl;
      cout << "   Example: gettemps /dev/ttyUSB0" << endl;

      // reset the SIGINT behaviour to default
      signal(SIGINT, SIG_DFL);

      // then send a kill to the PID of the process
      kill(getpid(),SIGINT);

    } else {

      if (arg1 == "-V")
      {
        cout << "gettemps version " << app_version << endl;

        // reset the SIGINT behaviour to default
        signal(SIGINT, SIG_DFL);

        // then send a kill to the PID of the process
        kill(getpid(),SIGINT);

      } else {

        str_comport = arg1;

      }

    }

  }


  // convert comport string to char
  char_comport = &str_comport[0];

  // see if we can open the comms port
  open_port_result = open_port(char_comport);



  // only go further when the port was opened successfully
  if (open_port_result == 2)
  {
    // port opened ok

    // fork process
    fork_return = fork();
    if (fork_return < 0)
    {
      cout << "Unable to run fork" << endl;
      exit(-1);
    }

    if (fork_return > 0)
    {
      // --- PARENT PROCESS (listen) ---
      // --- PARENT PROCESS (listen) ---
      // --- PARENT PROCESS (listen) ---
      //
      // This process will:
      // - open the serial port (close both processes if it can't open the port)
      // - listen for incoming characters on the com port
      // - close both processes when CTRL-C is pressed

      child_pid = fork_return;      
      int exitword=0;
      double listen_time_exit = listen_timeout+1000;     // max listen time, 8 seconds
      timeval listen_start, listen_stop;
      double listen_elapsed=0;
      
      // get the time
      gettimeofday(&listen_start, NULL);

      // loop until a number of seconds has lapsed
      while ((listen_elapsed < listen_time_exit) and (exitword != 2))
      {
 
        bufferstatus=read(fd, buf, 1);

        // only output when new data is available
        if (bufferstatus != 0)
        {

	  // output to stdout
          printf("%s", buf);
          fflush(stdout); 
          
          if (buf[0] == 'O')
          {
          
            // this might be the beginning of our exit word
            exitword=1;

            // test for next character match
            while ((listen_elapsed < listen_time_exit) and (exitword == 1))
            {
              bufferstatus=read(fd, buf, 1);

              if (bufferstatus != 0)
              {
                printf("%s", buf);  // output the character as per normal
                fflush(stdout); 

                // found another character in the read buffer
                if (buf[0] == 'k')
                {
                  // looking good.. 
                  
                  printf("\r\n");   // write a final crlf before we exit
                  exitword=2;       // gets us out of all loops and closes all activity

                } else {
                 
                  // false alarm
                  // exit out of this sub loop and return to main loop
                  exitword=0;
                
                }

              }

              // get the time
              gettimeofday(&listen_stop, NULL);

              //work out the difference
              listen_elapsed = (listen_stop.tv_sec - listen_start.tv_sec) * 1000.0; // sec to ms

            }

          }


	}

        // get the time
        gettimeofday(&listen_stop, NULL);

        //work out the difference
        listen_elapsed = (listen_stop.tv_sec - listen_start.tv_sec) * 1000.0; // sec to ms
        
      } // end listen-loop

      // terminate the child process and close the port

      // reset the SIGINT behaviour to default
      signal(SIGINT, SIG_DFL);

      // then send a kill to the PID of the child process
      kill(child_pid,SIGINT);

      // close the port
      close(fd);


    } else {

      // --- CHILD PROCESS (send) ---
      // --- CHILD PROCESS (send) ---
      // --- CHILD PROCESS (send) ---
      //
      // This process will:
      // - send one character on the serial port and then exit

      unsigned char send_byte[] = { 0x00 };
      double time_exit = listen_timeout;        // max send time, 7 seconds
      timeval start, stop;
      double elapsed=0;

      // get the time
      //gettimeofday(&start, NULL);

      // loop until a number of seconds has lapsed
      //while (elapsed < time_exit)
      //{
        write(fd, send_byte, 1);  // send data
         
        // get the time
      //  gettimeofday(&stop, NULL);

        //work out the difference
      //  elapsed = (stop.tv_sec - start.tv_sec) * 1000.0; // sec to ms
        
      //}

    }

  } else {

    cout << "Could not open port, program abort" << endl;

  }
 
  return 0;

}

