/*

  Arduino demo code for the PCA9535 I2C port expander.
  Compatible with Arduino IDE version 1.0.5
  Last modified: 26 January 2014  

*/

#include <Wire.h>

//  I2C 9535 device address is 0 1 0 0   0 0 0 (0x20, or 0d32)
#define PCA9535_ADDR 32

int ch0=0;
int ch1=0;

void setup() 
{
  
  Wire.begin();

  // setup channel 0 and 1
  Wire.beginTransmission(PCA9535_ADDR);
  Wire.write(6); // configure port 0 registers
  Wire.write(B00111111); // set bit 6+7 as output, the rest input
  Wire.write(B11111111); // set all as input
  Wire.endTransmission();
  
}


void loop() 
{
  
 
  PCA_ReadBytes(); // read the values of channel 0 and 1
  
 
  // channel 0
  
  if (bitRead(ch0,0))
  {
    // bit 0 of channel 0 is set high
    blinkLed(0,1);  // blink one time
  }
  if (bitRead(ch0,1))
  {
    // bit 1 of channel 0 is set high
    blinkLed(0,2);  // blink two times
  }
  if (bitRead(ch0,2))
  {
    // bit 2 of channel 0 is set high
    blinkLed(0,3);  // blink three times
  }
  


  // channel 1

  if (bitRead(ch1,0))
  {
    // bit 0 of channel 0 is set high
    blinkLed(1,1);  // blink one time
  }
  if (bitRead(ch1,1))
  {
    // bit 1 of channel 0 is set high
    blinkLed(1,2);  // blink two times
  }
 
 
  delay(1000);
  delay(1000);
  
    
}


void blinkLed(int lednr, int times)
{
  if (lednr==0)
  {
    lednr=B01000000; // bit 6 goes to the RED led 
  } else {
    lednr=B10000000; // bit 7 goes to the GREEN led
  }
    
  while (times>0)
  {
    
    // turn led on I/O 0, pin 6 or 7
    Wire.beginTransmission(PCA9535_ADDR);
    Wire.write(2); // select IO channel 0
    Wire.write(lednr); // turn on port on bit 6 or 7
    Wire.endTransmission();
    delay(100);
    all_off();
    delay(300);
   
    times--;
    
  }
}


void all_off()
{
    // turn off all outputs
    Wire.beginTransmission(PCA9535_ADDR);
    Wire.write(2); // select IO channel 0 output registers
    Wire.write(B00000000); // turn off all ports on channel 0
    Wire.endTransmission();
}


void PCA_ReadBytes()
{
  // reads the input registers of the PCA9535 device
  
  // read channel 0 first
  Wire.beginTransmission(PCA9535_ADDR);
  Wire.write(0); // we want to read channel 0 first
  Wire.endTransmission();
  Wire.requestFrom(PCA9535_ADDR,2); // read two bytes
  if(Wire.available())
  {
    ch0 = Wire.read(); // read channel 0
    ch1 = Wire.read(); // read other channel (channel 1)
  }
  Wire.endTransmission();  
}

