@echo off

set PROJECT=rs232-tempsensor_v2
set SPEED=16000000UL

set PORT=\\.\USBSER000
REM set PORT=\\.\COM20

set GCC_DEVICE=attiny85
set PGM_DEVICE=t85
REM set PGM_PROTO=avrispv2
set PGM_PROTO=usbtiny
set GCC_OPTIMISATION=-Os

REM GCC_OPTIMISATION="-O2"

set AVRTOOLS=C:\prg\winavr-20100110\bin


echo compile program
avr-gcc -g %GCC_OPTIMISATION% -Wall -mcall-prologues -DF_CPU=%SPEED% -mmcu=%GCC_DEVICE%   -c -o %PROJECT%.o %PROJECT%.c

echo create object file
avr-gcc -g %GCC_OPTIMISATION% -Wall -mcall-prologues -DF_CPU=%SPEED% -mmcu=%GCC_DEVICE% %PROJECT%.o -o %PROJECT%.obj

echo convert object file to hex file
avr-objcopy  -R .eeprom -O ihex %PROJECT%.obj %PROJECT%.hex

echo erase chip
avrdude -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -e


REM Writing 0xE2 to the Fuse Low Byte disables the CKDIV8 (use 0x62 to enable)
REM See http://electrons.psychogenic.com/modules/arms/art/14/AVRFusesHOWTOGuide.php
REM you only need to do this once
avrdude -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -U flash:w:%PROJECT%.hex  -U lfuse:w:0xC1:m 

echo write program to chip

avrdude -F -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -U flash:w:%PROJECT%.hex  


REM ping localhost -n 5 > nul


REM Show registers using the avr-list command
%AVRTOOLS%\avr-size -C --mcu=attiny84  %PROJECT%.obj
echo.


 pause