@echo off

set PROJECT=lcd-i2c
set SPEED=8000000UL

set PORT=\\.\USBSER000
REM set PORT=\\.\COM20

set GCC_DEVICE=attiny85
set PGM_DEVICE=t85
set PGM_PROTO=avrispv2
set GCC_OPTIMISATION=-Os
REM GCC_OPTIMISATION="-O2"
set AVRTOOLS=C:\winavr-20100110\bin



echo compile program
avr-gcc -g %GCC_OPTIMISATION% -Wall -mcall-prologues -DF_CPU=%SPEED% -mmcu=%GCC_DEVICE%   -c -o %PROJECT%.o %PROJECT%.c

echo create object file
avr-gcc -g %GCC_OPTIMISATION% -Wall -mcall-prologues -DF_CPU=%SPEED% -mmcu=%GCC_DEVICE% %PROJECT%.o -o %PROJECT%.obj

echo convert object file to hex file
avr-objcopy  -R .eeprom -O ihex %PROJECT%.obj %PROJECT%.hex

echo erase chip
avrdude -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -e


REM you only need to do this once
avrdude -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -U flash:w:%PROJECT%.hex  -U lfuse:w:0xE2:m


echo write program to chip

avrdude -F -c %PGM_PROTO% -P %PORT% -p %PGM_DEVICE% -U flash:w:%PROJECT%.hex  

echo avr-list output:
echo ----------------


REM format can either be set to SysV, Berkeley
REM file needs to be .obj for --mcu and percentages to work properly (does not work on .hex file)

REM Show registers using the avr-size command
%AVRTOOLS%\avr-size -C --mcu=%GCC_DEVICE%  %PROJECT%.obj > %PROJECT%_avr-size.txt

type %PROJECT%_avr-size.txt

pause